import funkin.game.PlayState;
import flixel.FlxG;
import hxvlc.flixel.FlxVideoSprite;

var bloom:CustomShader = new CustomShader("Bloom");
var awesomeBloom = false;
var bloomaMount = 1;
var title = new FlxSprite().loadGraphic(Paths.image("stages/robotnik/pingas"));
title.antialiasing = true;
title.alpha = 0.001;
if (FlxG.save.data.midsongvids_toggle) {
	var green:CustomShader = new CustomShader("NebulaGreenscreen");
	camGreen = new FlxCamera(0, 0, 960, 720);
	FlxG.cameras.add(camGreen, false);
	camGreen.bgColor = FlxColor.TRANSPARENT;
	camGreen.visible = false;
	var ytpmv = new FlxVideoSprite(0, 0);
	ytpmv.autoPause = false;
	ytpmv.load(Assets.getPath(Paths.video("Win_the_race")));
	ytpmv.shader = green;
}

function create() {
	if (FlxG.save.data.midsongvids_toggle) {
		FlxG.cameras.remove(camHUD, false);
		FlxG.cameras.add(camHUD, false);
		ytpmv.bitmap.onFormatSetup.add(function() {
			ytpmv.cameras = [camGreen];
			ytpmv.scale.set(1.5, 1.5);
			ytpmv.updateHitbox();
		});
		add(ytpmv);
	}
}

function postCreate() {
	bloom.data.Size.value = [10, 10];
	title.cameras = [camHUD2];
	title.screenCenter();
	add(title);
	// camHUD.alpha = 0.001;
}

/**
 * All video variables should be declared in this array, otherwise the custom focus handler
 * won't happen, and weird behaviour might happen.
 */
 var videosToHandle:Array<FlxVideoSprite> = [ytpmv];

function onSubstateOpen() {
	// check: should we be playing a video?
	// if yes: pause all videos that are visible (so playing)
	// otherwise: do nothing, the variables would be null anyway
	if (FlxG.save.data.midsongvids_toggle) {
		for (vid in videosToHandle) {
			if (vid.visible) {
				vid.pause();
			}
		}
	}
}

function onSubstateClose() {
	// check: should we be playing a video?
	// if yes: resume all videos that are visible (so playing)
	// otherwise: do nothing, the variables would be null anyway
	if (FlxG.save.data.midsongvids_toggle) {
		for (vid in videosToHandle) {
			if (vid.visible) {
				vid.resume();
			}
		}
	}
}

/** NOTE for: onFocusLost() | onFocus()
 * Since hxvlc.flixel.FlxVideo/FlxVideoSprite doesn't have an "isPlaying" variable, we
 * check if the video is visible instead. If it isn't, then the video shouldn't be
 * playing in the first place.								~ xavi. (thatoneidiotxav)
**/
function onFocusLost() {
	// check: should we be playing a video?
	// if yes: run other check
	if (FlxG.save.data.midsongvids_toggle) {
		// check: in unpaused gameplay?
		// if yes: pause video
		// otherwise: do nothing, videos should already be paused
		if (!paused) {
			for (vid in videosToHandle) {
				if (vid.visible) {
					vid.pause();
				}
			}
		}
	}
}

function onFocus() {
	// check: should we be playing a video?
	// if yes, run other check
	if (FlxG.save.data.midsongvids_toggle) {
		// check: in unpaused gameplay?
		if (!paused) {
			for (vid in videosToHandle) {
				if (vid.visible) {
					vid.resume();
				}
			}
		}
	}
}

function update(elapsed) {
	bloomaMount = FlxMath.lerp(bloomaMount, 1, elapsed);
	bloom.data.dim.value = [bloomaMount, bloomaMount];
}

function beatHit(beat) {
	if (beat % 2 == 0 && awesomeBloom)
		bloomaMount = 0.6;
}

function stepHit(step) {
	switch (step) {
		case 61:
		// FlxTween.tween(camHUD, {alpha: 1}, 0.1);
		case 320:
			FlxTween.tween(title, {alpha: 1}, (Conductor.stepCrochet / 1000) * 4);
		case 344:
			FlxTween.tween(title, {alpha: 0.001}, (Conductor.stepCrochet / 1000) * 4);
		case 640:
			camGame.followLerp = 0.08;
		case 704:
			camGame.followLerp = 0.04;
		case 768:
			camGame.followLerp = 0.08;
		case 832:
			camGame.followLerp = 0.04;
		case 976:
			if (FlxG.save.data.flashing_toggle) {
				camGame.addShader(bloom);
				awesomeBloom = true;
			}
		case 1355:
			if (FlxG.save.data.midsongvids_toggle) {
				ytpmv.play();
			}
		case 1358:
			if (FlxG.save.data.midsongvids_toggle) {
				camGreen.visible = true;
			}
		case 1359:
			// that's a great case right here if i do say so myself
		case 1488:
			awesomeBloom = false;
			camGame.removeShader(bloom);
			if (FlxG.save.data.midsongvids_toggle) {
				remove(ytpmv);
				FlxG.cameras.remove(camGreen);
			}
	}
}
